import sys
import logging
sys.path = ['C:/Users/contestant/OSEHRA/Dashboards/OSEHRA-Automated-Testing/Python'] + sys.path

from time import sleep
from suds.client import Client
import copy
import datetime

from pytz import timezone
from pytz import common_timezones
import pytz
import time
from ReplaceDatabase import ReplaceDatabase

if len(sys.argv) > 1:
	if sys.argv[1] == '-verbose':
		logdetail = 1
	else:
		logdetail = 0
else:
	logdetail = 0

url = 'http://127.0.0.1/WCFService/Service1.svc?wsdl'
client = Client(url, timeout=18000)

state = 'GEORGIA'
state_short = 'GA'
domain = 'GA.VA.GOV'
facility1_site_id = '556'
facility2_abbr = 'GVARMC'
facility3_abbr = 'GVAOPC'
patient_ssn = '100000006'
patient2_ssn = '100000007'
patient3_ssn = '100000008'

facility1 = state_short + ' VA HEALTH CARE SYSTEM'
facility2 = state_short + ' VA REGIONAL MEDICAL CENTER'
facility2_site_id = facility1_site_id + 'MC'
facility3 = state_short + ' VA OUTPATIENT CLINIC'
facility3_site_id = facility1_site_id + 'OC'

print 'initializing vista and sql db...'
print 'plesae wait...'
client.service.RestoreDBToSnapShot("SchedulingUseCase2Baseline")
ReplaceDatabase("C:/DBBackups/vista/usecase2/cache.dat")
sleep(60)

result = client.service.ImportProviders(facility1_site_id)
providers = client.service.GetAllProviders()
for p in providers.Provider:
	if p.Person.FirstName == 'PROVIDER' and p.Person.LastName == 'ONE':
		provider = copy.deepcopy(p)
		break;

for p in providers.Provider:
	if p.Person.FirstName == 'PROVIDER' and p.Person.LastName == 'TWO':
		provider2 = copy.deepcopy(p)
		break;

print 'setp 1'
print '\tadding appointment types to primary care sections'
result = client.service.GetFromVistaSiteId(facility1_site_id)
site = copy.deepcopy(result)
facilities = client.service.GetFacilities(site.Id)

for p in facilities.Facility:
	if p.Name == facility2:
		facility2_id = copy.copy(p.Id)
		break;

for p in facilities.Facility:
	if p.Name == facility3:
		facility3_id = copy.copy(p.Id)
		break;

sections = client.service.GetSections(facility2_id)
for p in sections.Section:
	if p.Name == 'PRIMARY CARE':
		section1 = copy.deepcopy(p)
		break;

appTypeCats = client.service.GetAppointmentTypeCategories(facility1_site_id)
for p in appTypeCats.AppointmentTypeCategory:
	if p.Name == 'REGULAR':
		regularAppTypeCat = copy.deepcopy(p)
		break;

for p in appTypeCats.AppointmentTypeCategory:
	if p.Name == 'COMPENSATION & PENSION':
		compAndPensionAppTypeCat = copy.deepcopy(p)
		break;

appTypes = client.factory.create('ns0:ArrayOfAppointmentType')
appType = client.factory.create('ns0:AppointmentType')
appType.AppointmentTypeCategory = regularAppTypeCat
appType.Name = 'INITIAL'
appType.Duration = '30'
appType.DSSPrimaryStopCode = '323 TELEPHONE/NEUROLOGY'

appType2 = client.factory.create('ns0:AppointmentType')
appType2.AppointmentTypeCategory = regularAppTypeCat
appType2.Name = 'FOLLOW-UP'
appType2.Duration = '15'
appType2.DSSPrimaryStopCode = '323 TELEPHONE/NEUROLOGY'
appTypes.AppointmentType = [appType, appType2]
section1.AppointmentTypes = appTypes
result = client.service.UpdateSection(section1)
section1 = copy.deepcopy(result)

sections = client.service.GetSections(facility3_id)
for p in sections.Section:
	if p.Name == 'PRIMARY CARE':
		section2 = copy.deepcopy(p)
		break;

appTypes = client.factory.create('ns0:ArrayOfAppointmentType')
appType3 = client.factory.create('ns0:AppointmentType')
appType3.AppointmentTypeCategory = compAndPensionAppTypeCat
appType3.Name = 'C&P'
appType3.Duration = '30'
appType3.DSSPrimaryStopCode = '323 TELEPHONE/NEUROLOGY'
appType3.DSSCreditStopCode = '450 BRONCHOSCOPY'

appType4 = client.factory.create('ns0:AppointmentType')
appType4.AppointmentTypeCategory = regularAppTypeCat
appType4.Name = 'REGULAR'
appType4.Duration = '15'
appType4.DSSPrimaryStopCode = '323 TELEPHONE/NEUROLOGY'
appType4.DSSCreditStopCode = '450 BRONCHOSCOPY'
appTypes.AppointmentType = [appType3, appType4]
section2.AppointmentTypes = appTypes
result = client.service.UpdateSection(section2)
section2 = copy.deepcopy(result)

print 'checkpoint 1'
if logdetail == 1:
	print section1
print 'appointment types are added to primary care section on ' + facility2
if logdetail == 1:
	print section2
print 'appointment types are added to primary care section on ' + facility3

sleep(5)
print 'step 2'
print '\tcreating resource: adding a provider'
resource = client.factory.create('ns0:Resource')
holds = client.factory.create('ns0:ArrayOfHold')
blocks = client.factory.create('ns0:ArrayOfBlock')
schdPolicies = client.factory.create('ns0:ArrayOfSchedulingPolicy')
blocks.Block = []
resource.Blocks = blocks
holds.Hold = []
resource.Holds = holds
schdPolicies.SchedulingPolicy = []
resource.Name = 'case2 step 2 provider'
resource.Section = section2
resource.Type = 'Provider'
resource.FullfillingResourceId = provider2.Id
result = client.service.AddResource(resource)
resource_result = copy.deepcopy(result)

print '\tcreating resource: adding a room to primary care'
room = client.factory.create('ns0:Room')
room.Site = site
room.Name = 'X-Ray Room'
result = client.service.AddRoom(room)
room = copy.deepcopy(result)

resource2 = client.factory.create('ns0:Resource')
holds = client.factory.create('ns0:ArrayOfHold')
blocks = client.factory.create('ns0:ArrayOfBlock')
schdPolicies = client.factory.create('ns0:ArrayOfSchedulingPolicy')
blocks.Block = []
resource2.Blocks = blocks
holds.Hold = []
resource2.Holds = holds
schdPolicies.SchedulingPolicy = []
resource2.Name = 'case2 step 2 room'
resource2.Section = section2
resource2.Type = 'Room'
resource2.FullfillingResourceId = room.Id
result = client.service.AddResource(resource2)
resource2_result = copy.deepcopy(result)

print '\tcreating resource: adding an equiment to primary care'
equipment = client.factory.create('ns0:Equipment')
equipment.Site = site
equipment.Name = 'X-Ray'
result = client.service.AddEquipment(equipment)
equipment = copy.deepcopy(result)

resource3 = client.factory.create('ns0:Resource')
holds = client.factory.create('ns0:ArrayOfHold')
blocks = client.factory.create('ns0:ArrayOfBlock')
schdPolicies = client.factory.create('ns0:ArrayOfSchedulingPolicy')
blocks.Block = []
resource3.Blocks = blocks
holds.Hold = []
resource3.Holds = holds
schdPolicies.SchedulingPolicy = []
resource3.Name = 'case2 step 2 equipment'
resource3.Section = section2
resource3.Type = 'Equipment'
resource3.FullfillingResourceId = equipment.Id
result = client.service.AddResource(resource3)
resource3_result = copy.deepcopy(result)

sleep(5)
print 'step 3'
print '\tadding scheudling policy to provider in primary care'
schPolicies = client.factory.create('ns0:ArrayOfSchedulingPolicy')
schPolicy = client.factory.create('ns0:SchedulingPolicy')
schPolicy.DayOfWeek = '1'
schPolicy.EndEffectDate = '2014-01-15'
schPolicy.StartEffectDate = '2013-12-04'
schPolicies.SchedulingPolicy = schPolicy
resource2_result.SchedulingPolicies = schPolicies
result = client.service.UpdateResource(resource2_result)
resource2_result = copy.deepcopy(result)
print '\tadding scheudling policy to equiment in primary care'
resource3_result.SchedulingPolicies = schPolicies
result = client.service.UpdateResource(resource3_result)
resource3_result = copy.deepcopy(result)

sleep(5)
print 'step 4'
print '\tadding scheudling policy to provider in primary care'
resource_result.SchedulingPolicies = schPolicies
result = client.service.UpdateResource(resource_result)
resource_result = copy.deepcopy(result)

print 'checkpoint 2'
if logdetail == 1:
	print resource_result
print '\tscheudling policy is added to a provider in primary care'

sleep(5)
print 'step 5'
print '\tcreate holds on provider in primary care'
holds = client.factory.create('ns0:ArrayOfHold')
hold = client.factory.create('ns0:Hold')
hold.AutoReleaseAt = datetime.datetime.strptime('2014-01-03 08:00:00', '%Y-%m-%d %H:%M:%S')
hold.PeriodEnd = datetime.datetime.strptime('2014-01-05 08:00:00', '%Y-%m-%d %H:%M:%S')
hold.PeriodStart = datetime.datetime.strptime('2014-01-04 08:00:00', '%Y-%m-%d %H:%M:%S')
holds.Hold = hold
resource_result.Holds = holds
result = client.service.UpdateResource(resource_result)
resource_result = copy.deepcopy(result)

print 'checkpoint 3'
if logdetail == 1:
	print resource_result
print '\tthere is a hold on the 4 jan 2014'
print '\tthere is a release of the on the 3 jan 2014'

sleep(5)
print 'step 6'
#holds2 = client.factory.create('ns0:ArrayOfHold')
hold2 = client.factory.create('ns0:Hold')
hold2.PeriodEnd = datetime.datetime.strptime('2014-01-06 08:00:00', '%Y-%m-%d %H:%M:%S')
hold2.PeriodStart = datetime.datetime.strptime('2014-01-05 08:00:00', '%Y-%m-%d %H:%M:%S')
resource_result.Holds.Hold.append(hold2)
result = client.service.UpdateResource(resource_result)
resource_result = copy.deepcopy(result)

resource_result.Holds.Hold[1].PeriodEnd = datetime.datetime.strptime('2014-01-05 08:00:00', '%Y-%m-%d %H:%M:%S')
result = client.service.UpdateResource(resource_result)
resource_result = copy.deepcopy(result)

print 'checkpoint 4'
if logdetail == 1:
	print resource_result
print '\tthere is a hold on the 5 jan 2014'
print '\tthere is a release of the on the 5 jan 2014'

sleep(5)
print 'step 7'
print '\tcreating a block on a provider in primary care'
blocks = client.factory.create('ns0:ArrayOfBlock')
block = client.factory.create('ns0:Block')
block.PeriodStart = datetime.datetime.strptime('2013-12-05 17:00:00', '%Y-%m-%d %H:%M:%S')
block.PeriodEnd = datetime.datetime.strptime('2013-12-05 20:00:00', '%Y-%m-%d %H:%M:%S')
blocks.Block = block
resource_result.Blocks = blocks
result = client.service.UpdateResource(resource_result)
resource_result = copy.deepcopy(result)

print 'checkpoint 5'
if logdetail == 1:
	print resource_result
print '\tthere is a block for 9am - 12pm on the 5 dec 2013'

sleep(5)
print 'step 8'
print '\tblocking a exiting scheduled patient appointment'
holds = client.factory.create('ns0:ArrayOfHold')
blocks = client.factory.create('ns0:ArrayOfBlock')
schdPolicies = client.factory.create('ns0:ArrayOfSchedulingPolicy')
blocks.Block = []
resource.Blocks = blocks
holds.Hold = []
resource.Holds = holds
schdPolicies.SchedulingPolicy = []
resource.Name = 'case 2 step 8 provider,one'
resource.Section = section1
resource.Type = 'Provider'
resource.FullfillingResourceId = provider.Id
result = client.service.AddResource(resource)
resource8_result = copy.deepcopy(result)

schPolicies = client.factory.create('ns0:ArrayOfSchedulingPolicy')
schPolicy = client.factory.create('ns0:SchedulingPolicy')
schPolicy.DayOfWeek = '1'
schPolicy.EndEffectDate = '2014-01-15'
schPolicy.StartEffectDate = '2013-01-04'
schPolicies.SchedulingPolicy = schPolicy
resource8_result.SchedulingPolicies = schPolicies
result = client.service.UpdateResource(resource8_result)
resource8_result = copy.deepcopy(result)

slots = client.factory.create('ns0:ArrayOfSlot')
slot = client.factory.create('ns0:Slot')
slot.Time = 'PT15H' #10am est
slot.Length = 30
slot.Capacity = 1
slot.AppointmentType = resource8_result.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot)

slot2 = client.factory.create('ns0:Slot')
slot2.Time = 'PT15H30M'
slot2.Length = 30
slot2.Capacity = 1
slot2.AppointmentType = resource8_result.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot2)

slot3 = client.factory.create('ns0:Slot')
slot3.Time = 'PT16H'
slot3.Length = 30
slot3.Capacity = 1
slot3.AppointmentType = resource8_result.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot3)

slot4 = client.factory.create('ns0:Slot')
slot4.Time = 'PT16H30M'
slot4.Length = 30
slot4.Capacity = 1
slot4.AppointmentType = resource8_result.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot4)

slot5 = client.factory.create('ns0:Slot')
slot5.Time = 'PT17H'
slot5.Length = 30
slot5.Capacity = 1
slot5.AppointmentType = resource8_result.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot5)

slot6 = client.factory.create('ns0:Slot')
slot6.Time = 'PT17H30M'
slot6.Length = 30
slot6.Capacity = 1
slot6.AppointmentType = resource8_result.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot6)

slot7 = client.factory.create('ns0:Slot')
slot7.Time = 'PT18H'
slot7.Length = 30
slot7.Capacity = 5
slot7.AppointmentType = resource8_result.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot7)

slot8 = client.factory.create('ns0:Slot')
slot8.Time = 'PT18H30M'
slot8.Length = 30
slot8.Capacity = 5
slot8.AppointmentType = resource8_result.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot8)

slot9 = client.factory.create('ns0:Slot')
slot9.Time = 'PT19H'
slot9.Length = 30
slot9.Capacity = 5
slot9.AppointmentType = resource8_result.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot9)

slot10 = client.factory.create('ns0:Slot')
slot10.Time = 'PT19H30M'
slot10.Length = 30
slot10.Capacity = 5
slot10.AppointmentType = resource8_result.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot10)
resource8_result.SchedulingPolicies.SchedulingPolicy[0].Slots = slots
result = client.service.UpdateResource(resource8_result)
resource8_result = copy.deepcopy(result)

schPolicy.DayOfWeek = '2'
schPolicy.EndEffectDate = '2014-01-15'
schPolicy.StartEffectDate = '2013-01-04'
resource8_result.SchedulingPolicies.SchedulingPolicy.append(schPolicy)
resource8_result.SchedulingPolicies.SchedulingPolicy[1].Slots = slots
result = client.service.UpdateResource(resource8_result)
resource8_result = copy.deepcopy(result)

schPolicy.DayOfWeek = '3'
schPolicy.EndEffectDate = '2014-01-15'
schPolicy.StartEffectDate = '2013-01-04'
resource8_result.SchedulingPolicies.SchedulingPolicy.append(schPolicy)
resource8_result.SchedulingPolicies.SchedulingPolicy[2].Slots = slots
result = client.service.UpdateResource(resource8_result)
resource8_result = copy.deepcopy(result)

schPolicy.DayOfWeek = '4'
schPolicy.EndEffectDate = '2014-01-15'
schPolicy.StartEffectDate = '2013-01-04'
resource8_result.SchedulingPolicies.SchedulingPolicy.append(schPolicy)
resource8_result.SchedulingPolicies.SchedulingPolicy[3].Slots = slots
result = client.service.UpdateResource(resource8_result)
resource8_result = copy.deepcopy(result)

schPolicy.DayOfWeek = '5'
schPolicy.EndEffectDate = '2014-01-15'
schPolicy.StartEffectDate = '2013-01-04'
resource8_result.SchedulingPolicies.SchedulingPolicy.append(schPolicy)
resource8_result.SchedulingPolicies.SchedulingPolicy[4].Slots = slots
result = client.service.UpdateResource(resource8_result)
resource8_result = copy.deepcopy(result)


patients = client.service.SearchPatients(facility1_site_id,patient_ssn)
result = client.service.GetPatient(patients[0])
patient = copy.deepcopy(result)

appointment = client.factory.create('ns0:Appointment')
resourcearray = client.factory.create('ns0:ArrayOfResource')
resourcearray.Resource=resource8_result
tzinfo=pytz.utc

appointment.Patient = patient
appointment.Length = 30
appointment.Section = resource8_result.Section
appTimeStamp = datetime.datetime.strptime('2013-12-05 19:00:00', '%Y-%m-%d %H:%M:%S')#datetime.datetime(2013,12,16,16,00,00) #datetime.datetime.utcnow()
appointment.Time = appTimeStamp
appointment.Resources = resourcearray
appointment.AppointmentType=resource8_result.Section.AppointmentTypes.AppointmentType[0]
appointment.Status='Unknown'
try:
    result = client.service.CreateAppointment(appointment)
    appointment1 = copy.deepcopy(result)
    print 'current appointment status:  ' + appointment1.Status
except Exception, e:
    print 'error:  '
    print e
    sys.exc_clear()

blocks = client.factory.create('ns0:ArrayOfBlock')
block = client.factory.create('ns0:Block')
block.PeriodStart = datetime.datetime.strptime('2013-12-05 08:00:00', '%Y-%m-%d %H:%M:%S')
block.PeriodEnd = datetime.datetime.strptime('2013-12-06 08:00:00', '%Y-%m-%d %H:%M:%S')
blocks.Block = block
resource8_result.Blocks = blocks
result = client.service.UpdateResource(resource8_result)
resource8_result = copy.deepcopy(result)

print 'checkpoint 6'
if logdetail == 1:
	print client.service.GetAppointment(appointment1.Id)
print '\tscheduled patient appintment is canceled due to a block'
print '\tappointment after block:  ' + client.service.GetAppointment(appointment1.Id).Status

sleep(5)
print 'step 9'
print '\tcreating communication queue for a canceled appointment'
comqueue = client.factory.create('ns0:CommunicationQueueItem')
comqueue.Recipient = patient.Id
comqueue.SendBy = datetime.datetime(2013,5,31)
comqueue.SentOn = datetime.datetime(2013,5,30)
comqueue.Subject = 'Appointment/Cancel/Re-Schedule'
comqueue.Body = 'Schedule Conflict:  Blocked'
comqueue.Appointment = appointment1

result = client.service.AddToCommunicationQueue(comqueue)
comqueue_result = copy.deepcopy(result)

print 'checkpoint 7'
if logdetail == 1:
	print comqueue_result
print '\tthere is a communcation queue due block on cancelation of appointment'

sleep(5)
print 'step 10'
print '\tcreating a group appointment'
facilities = client.service.GetFacilities(site.Id)
for p in facilities.Facility:
	if p.Name == facility2:
		facility2_id = copy.copy(p.Id)
		break;

sections = client.service.GetSections(facility2_id)
for p in sections.Section:
	if p.Name == 'PRIMARY CARE':
		section10 = copy.deepcopy(p)
		break;

		
resources = client.service.GetAllResources(section10.Id)
for p in resources.Resource:
	if p.Name == 'case 2 step 8 provider,one':
		resource10 = copy.deepcopy(p)
		break;

patients = client.service.SearchPatients(facility1_site_id,patient2_ssn)
patient2 = copy.deepcopy(client.service.GetPatient(patients[0]))

patients = client.service.SearchPatients(facility1_site_id,patient3_ssn)
patient3 = copy.deepcopy(client.service.GetPatient(patients[0]))

appointment2 = client.factory.create('ns0:Appointment')
resourcearray = client.factory.create('ns0:ArrayOfResource')
resourcearray.Resource=resource10

appointment2.Patient = patient2
appointment2.Length = 30
appointment2.Section = resource10.Section
appTimeStamp = datetime.datetime(2013,12,19,21,30,00)
appointment2.Time = appTimeStamp
appointment2.Resources = resourcearray
appointment2.AppointmentType=resource10.Section.AppointmentTypes.AppointmentType[0]
appointment2.Status='Unknown'
try:
    result = client.service.CreateAppointment(appointment2)
    appointment2 = copy.deepcopy(result)
    print 'current appointment status:  ' + appointment2.Status
except Exception, e:
    print 'error:  '
    print e
    sys.exc_clear()

appointment3 = client.factory.create('ns0:Appointment')
resourcearray = client.factory.create('ns0:ArrayOfResource')
resourcearray.Resource=resource10
appointment3.Patient = patient3
appointment3.Length = 30
appointment3.Section = resource10.Section
appTimeStamp = datetime.datetime(2013,12,19,21,30,00)
appointment3.Time = appTimeStamp
appointment3.Resources = resourcearray
appointment3.AppointmentType=resource10.Section.AppointmentTypes.AppointmentType[0]
appointment3.Status='Unknown'
try:
    result = client.service.CreateAppointment(appointment3)
    appointment3 = copy.deepcopy(result)
    print 'current appointment status:  ' + appointment3.Status
except Exception, e:
    print 'error:  '
    print e
    sys.exc_clear()

print 'checkpoint 8'
if logdetail == 1:
	print client.service.GetAppointment(appointment2.Id)
	print client.service.GetAppointment(appointment3.Id)
print '\tthere is a group appointment scheduled'

sleep(5)
print 'step 11'
print '\tcreating pre appointment patient instructions'
facilities = client.service.GetFacilities(site.Id)
for p in facilities.Facility:
	if p.Name == facility2:
		facility2_id = copy.copy(p.Id)
		break;

sections = client.service.GetSections(facility2_id)
for p in sections.Section:
	if p.Name == 'PRIMARY CARE':
		section11 = copy.deepcopy(p)
		break;

apinstructions = client.factory.create('ns0:ArrayOfPatientInstructions')
pinstructions = client.factory.create('ns0:PatientInstructions')
pinstructions.Instructions = 'case 2 step 11 pre appointment patient instructions'
pinstructions.Type = 'PreAppointment'

apinstructions.PatientInstructions = pinstructions
section11.AppointmentTypes.AppointmentType[0].PatientInstructions = apinstructions
result = client.service.UpdateSection(section11)
section11 = copy.deepcopy(result)

print 'checkpoint 9'
if logdetail == 1:
	print section11
print 'there is pre appointment patient instructions'

sleep(5)
print 'step 12'
print '\tcreating mutiple app types on the same day'
facilities = client.service.GetFacilities(site.Id)
for p in facilities.Facility:
	if p.Name == facility2:
		facility2_id = copy.copy(p.Id)
		break;

sections = client.service.GetSections(facility2_id)
for p in sections.Section:
	if p.Name == 'PRIMARY CARE':
		section5 = copy.deepcopy(p)
		break;

appTypeCats2 = client.service.GetAppointmentTypeCategories(facility1_site_id)
for p in appTypeCats2.AppointmentTypeCategory:
	if p.Name == 'REGULAR':
		regularAppTypeCat2 = copy.deepcopy(p)
		break;
		
appTypes2 = client.factory.create('ns0:ArrayOfAppointmentType')
appType3 = client.factory.create('ns0:AppointmentType')
appType3.AppointmentTypeCategory = regularAppTypeCat2
appType3.Name = 'Medication Refill'
appType3.Duration = '30'
appType3.DSSPrimaryStopCode = '323 TELEPHONE/NEUROLOGY'

appType4 = client.factory.create('ns0:AppointmentType')
appType4.AppointmentTypeCategory = regularAppTypeCat2
appType4.Name = 'New Patient'
appType4.Duration = '15'
appType4.DSSPrimaryStopCode = '323 TELEPHONE/NEUROLOGY'
section5.AppointmentTypes.AppointmentType.append(appType3)
section5.AppointmentTypes.AppointmentType.append(appType4)

result = client.service.UpdateSection(section5)
section5 = copy.deepcopy(result)

sleep(5)
resource = client.factory.create('ns0:Resource')
holds = client.factory.create('ns0:ArrayOfHold')
blocks = client.factory.create('ns0:ArrayOfBlock')
schdPolicies = client.factory.create('ns0:ArrayOfSchedulingPolicy')
blocks.Block = []
resource.Blocks = blocks
holds.Hold = []
resource.Holds = holds
schdPolicies.SchedulingPolicy = []
resource.Name = 'case2 step 12'
resource.Section = section5
resource.Type = 'Provider'
resource.FullfillingResourceId = provider2.Id
result = client.service.AddResource(resource)
resource_result = copy.deepcopy(result)

schPolicies = client.factory.create('ns0:ArrayOfSchedulingPolicy')
schPolicy = client.factory.create('ns0:SchedulingPolicy')
schPolicy.DayOfWeek = '1'
schPolicy.EndEffectDate = '2014-01-15'
schPolicy.StartEffectDate = '2013-01-04'
schPolicies.SchedulingPolicy = schPolicy
resource_result.SchedulingPolicies = schPolicies
result = client.service.UpdateResource(resource_result)
resource_result = copy.deepcopy(result)


slots = client.factory.create('ns0:ArrayOfSlot')
slot = client.factory.create('ns0:Slot')
slot.Time = 'PT15H'
slot.Length = 30
slot.Capacity = 2
slot.AppointmentType = resource_result.Section.AppointmentTypes.AppointmentType[2]
slots.Slot.append(slot)

slot2 = client.factory.create('ns0:Slot')
slot2.Time = 'PT15H30M'
slot2.Length = 30
slot2.Capacity = 2
slot2.AppointmentType = resource_result.Section.AppointmentTypes.AppointmentType[2]
slots.Slot.append(slot2)

slot3 = client.factory.create('ns0:Slot')
slot3.Time = 'PT16H'
slot3.Length = 30
slot3.Capacity = 2
slot3.AppointmentType = resource_result.Section.AppointmentTypes.AppointmentType[2]
slots.Slot.append(slot3)

slot4 = client.factory.create('ns0:Slot')
slot4.Time = 'PT16H30M'
slot4.Length = 30
slot4.Capacity = 2
slot4.AppointmentType = resource_result.Section.AppointmentTypes.AppointmentType[2]
slots.Slot.append(slot4)

slot5 = client.factory.create('ns0:Slot')
slot5.Time = 'PT17H'
slot5.Length = 30
slot5.Capacity = 2
slot5.AppointmentType = resource_result.Section.AppointmentTypes.AppointmentType[2]
slots.Slot.append(slot5)

slot6 = client.factory.create('ns0:Slot')
slot6.Time = 'PT17H30M'
slot6.Length = 30
slot6.Capacity = 2
slot6.AppointmentType = resource_result.Section.AppointmentTypes.AppointmentType[2]
slots.Slot.append(slot6)

slot7 = client.factory.create('ns0:Slot')
slot7.Time = 'PT18H'
slot7.Length = 30
slot7.Capacity = 2
slot7.AppointmentType = resource_result.Section.AppointmentTypes.AppointmentType[2]
slots.Slot.append(slot7)

slot8 = client.factory.create('ns0:Slot')
slot8.Time = 'PT18H30M'
slot8.Length = 30
slot8.Capacity = 2
slot8.AppointmentType = resource_result.Section.AppointmentTypes.AppointmentType[2]
slots.Slot.append(slot8)

slot9 = client.factory.create('ns0:Slot')
slot9.Time = 'PT19H'
slot9.Length = 30
slot9.Capacity = 2
slot9.AppointmentType = resource_result.Section.AppointmentTypes.AppointmentType[2]
slots.Slot.append(slot9)

slot10 = client.factory.create('ns0:Slot')
slot10.Time = 'PT19H30M'
slot10.Length = 30
slot10.Capacity = 2
slot10.AppointmentType = resource_result.Section.AppointmentTypes.AppointmentType[2]
slots.Slot.append(slot10)

slot11 = client.factory.create('ns0:Slot')
slot11.Time = 'PT20H'
slot11.Length = 15
slot11.Capacity = 2
slot11.AppointmentType = resource_result.Section.AppointmentTypes.AppointmentType[3]
slots.Slot.append(slot11)

slot12 = client.factory.create('ns0:Slot')
slot12.Time = 'PT20H15M'
slot12.Length = 15
slot12.Capacity = 2
slot12.AppointmentType = resource_result.Section.AppointmentTypes.AppointmentType[3]
slots.Slot.append(slot12)

slot13 = client.factory.create('ns0:Slot')
slot13.Time = 'PT20H30M'
slot13.Length = 15
slot13.Capacity = 2
slot13.AppointmentType = resource_result.Section.AppointmentTypes.AppointmentType[3]
slots.Slot.append(slot13)

slot14 = client.factory.create('ns0:Slot')
slot14.Time = 'PT20H45M'
slot14.Length = 15
slot14.Capacity = 2
slot14.AppointmentType = resource_result.Section.AppointmentTypes.AppointmentType[3]
slots.Slot.append(slot14)

resource_result.SchedulingPolicies.SchedulingPolicy[0].Slots = slots
result = client.service.UpdateResource(resource_result)
resource_result = copy.deepcopy(result)

schPolicy.DayOfWeek = '2'
schPolicy.EndEffectDate = '2014-01-15'
schPolicy.StartEffectDate = '2013-01-04'
resource_result.SchedulingPolicies.SchedulingPolicy.append(schPolicy)
resource_result.SchedulingPolicies.SchedulingPolicy[1].Slots = slots
result = client.service.UpdateResource(resource_result)
resource_result = copy.deepcopy(result)

schPolicy.DayOfWeek = '3'
schPolicy.EndEffectDate = '2014-01-15'
schPolicy.StartEffectDate = '2013-01-04'
resource_result.SchedulingPolicies.SchedulingPolicy.append(schPolicy)
resource_result.SchedulingPolicies.SchedulingPolicy[2].Slots = slots
result = client.service.UpdateResource(resource_result)
resource_result = copy.deepcopy(result)

schPolicy.DayOfWeek = '4'
schPolicy.EndEffectDate = '2014-01-15'
schPolicy.StartEffectDate = '2013-01-04'
resource_result.SchedulingPolicies.SchedulingPolicy.append(schPolicy)
resource_result.SchedulingPolicies.SchedulingPolicy[3].Slots = slots
result = client.service.UpdateResource(resource_result)
resource_result = copy.deepcopy(result)

schPolicy.DayOfWeek = '5'
schPolicy.EndEffectDate = '2014-01-15'
schPolicy.StartEffectDate = '2013-01-04'
resource_result.SchedulingPolicies.SchedulingPolicy.append(schPolicy)
resource_result.SchedulingPolicies.SchedulingPolicy[4].Slots = slots
result = client.service.UpdateResource(resource_result)
resource_result_12 = copy.deepcopy(result)

print 'checkpoint 10'
if logdetail == 1:
	print section5
print '\tthere is multple app types on the same day'

sleep(5)
print 'step 13'
print '\tcreating a block for multiple days with a reason'
blocks = client.factory.create('ns0:ArrayOfBlock')
block = client.factory.create('ns0:Block')
block.PeriodStart = datetime.datetime.strptime('2013-05-06 19:00:00', '%Y-%m-%d %H:%M:%S')
block.PeriodEnd = datetime.datetime.strptime('2013-05-06 20:00:00', '%Y-%m-%d %H:%M:%S')
block.Reason = 'morning meeting day 1'

block2 = client.factory.create('ns0:Block')
block2.PeriodStart = datetime.datetime.strptime('2013-05-07 19:00:00', '%Y-%m-%d %H:%M:%S')
block2.PeriodEnd = datetime.datetime.strptime('2013-05-07 20:00:00', '%Y-%m-%d %H:%M:%S')
block2.Reason = 'morning meeting day 2'
blocks.Block = [block, block2]
resource_result_12.Blocks = blocks
result = client.service.UpdateResource(resource_result_12)
resource_result_13 = copy.deepcopy(result)

print 'checkpoint 11'
if logdetail == 1:
	print resource_result_13
print '\tthere is a block for multiple days with a reason'

sleep(5)
print 'step 14'
print '\tcreating a block with reoccurring period'

recur = client.factory.create('ns0:Recur')
recur.RecurringStart = datetime.datetime.strptime('2013-05-06 08:00:00', '%Y-%m-%d %H:%M:%S')
recur.RecurringEnd = datetime.datetime.strptime('2013-06-01 08:00:00', '%Y-%m-%d %H:%M:%S')
recur.RecurringFrequency = 'Weekly'
recur.RecurringInterval = '3'
resource_result_13.Blocks.Block[0].Recur = recur
result = client.service.UpdateResource(resource_result_13)
resource14 = copy.deepcopy(result)

print 'checkpoint 12'
if logdetail == 1:
	print resource14
print '\tthere is a block with reoccurring period'

sleep(5)
print 'step 15'
print '\ttrack appointment cancelation due to shcedules being blocked'

print 'checkpoint 13'
if logdetail == 1:
	print comqueue_result
print '\tthere is a communcation queue due block on cancelation of appointment'

sleep(5)
print 'step 16'
print '\tchanging appointment types on a scheduled appointment'
#patients = client.service.SearchPatients(facility1_site_id,patient_ssn)
#patient = client.service.GetPatient(patients[0])

apps = client.service.GetAppointmentsForPatient(patient.Id,datetime.datetime(2013,12,04,00,00,00),datetime.datetime(2013,12,06,00,00,00))
appointment16 = copy.deepcopy(apps.Appointment[0])
appointment16.AppointmentType = appointment16.Section.AppointmentTypes.AppointmentType[1]
result = client.service.UpdateAppointment(appointment16)
appointment16 = copy.deepcopy(result)

print 'checkpoint 14'
if logdetail == 1:
	print appointment16
print '\tappointment types are changed on a scheduled appointment'

sleep(5)
print 'step 17'
print '\tadding, modifying, and deleting appointment types from a section'
facilities = client.service.GetFacilities(client.service.GetFromVistaSiteId(facility1_site_id).Id)
for p in facilities.Facility:
	if p.Name == facility2:
		facility2_id = copy.copy(p.Id)
		break;

sections = client.service.GetSections(facility2_id)
for p in sections.Section:
	if p.Name == 'PRIMARY CARE':
		before_section17 = copy.deepcopy(p)
		section17 = copy.deepcopy(p)
		break;

appTypeCats2 = client.service.GetAppointmentTypeCategories(facility1_site_id)
for p in appTypeCats2.AppointmentTypeCategory:
	if p.Name == 'REGULAR':
		regularAppTypeCat2 = copy.deepcopy(p)
		break;
		
appTypes3 = client.factory.create('ns0:ArrayOfAppointmentType')
appType5 = client.factory.create('ns0:AppointmentType')
appType5.AppointmentTypeCategory = regularAppTypeCat2
appType5.Name = 'Medication Refill2'
appType5.Duration = '30'
appType5.DSSPrimaryStopCode = '323 TELEPHONE/NEUROLOGY'

section17.AppointmentTypes.AppointmentType.append(appType5)
section17.AppointmentTypes.AppointmentType[3].Name = 'New Patient Updated'

result = client.service.UpdateSection(section17)
section17 = copy.deepcopy(result)

print 'checkpoint 15'
if logdetail == 1:
	print 'before:'
	print before_section17
	print 'after:'
	print section17
print '\tappintment types got added, modified and deleted from a section'

sleep(5)
print 'step 18'
print '\tassigning overbooking privileges to a provider'
result = client.service.GetResource(resource14.Id)
resource18 = copy.deepcopy(result)
resource18.AllowOverbooking = 1
result = client.service.UpdateResource(resource18)
resource18 = copy.deepcopy(result)

print 'checkpoint 16'
if logdetail == 1:
	print resource18
print '\toverbooking is assigned to a provider'

sleep(5)
print 'step 19'
print '\tassigning a provider to multiple sections'
resource = client.factory.create('ns0:Resource')
holds = client.factory.create('ns0:ArrayOfHold')
blocks = client.factory.create('ns0:ArrayOfBlock')
schdPolicies = client.factory.create('ns0:ArrayOfSchedulingPolicy')
blocks.Block = []
resource.Blocks = blocks
holds.Hold = []
resource.Holds = holds
schdPolicies.SchedulingPolicy = []
resource.Name = 'case2 step 19 provider, one'
resource.Section = section2
resource.Type = 'Provider'
resource.FullfillingResourceId = provider.Id
result = client.service.AddResource(resource)
resource_result = copy.deepcopy(result)
print 'checkpoint 17'
if logdetail == 1:
	print resource_result
	print resource10
print '\ta provider is assigned to multiple sections'